function mpc =Network1																										
%% INESC TEC 27/05/2020																										
%% MATPOWER Case Format : Version 2																										
mpc.version = '2';																										
																										
%%-----  Power Flow Data  -----%%																										
%% system MVA base																										
mpc.baseMVA = 100;																										
																										
%% system voltage levels (kV)																										
mpc.V_levels = [																										
	30	60																								
];																										
																										
%% bus data																										
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	hasGEN	isLOAD	SNOM_MVA	SX	SY	GX	GY						
mpc.bus = [																										
	1	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	2	3	0	0	0.02	0	1	1	0	60	1	1.1	0.9	1	0	0	0	0	0	0;						
	3	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	4	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	5	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0	0	0	0	0;						
	6	1	0.0616	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	7	1	0.101	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	8	1	0.049	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	9	1	0.594	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	10	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	7.4	0	0	0	0;						
	11	1	0.687	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.6	0	0	0	0;						
	12	1	0.0287	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	13	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	14	1	1.16	0	0	0	1	1	0	30	1	1.1	0.9	0	1	2.23	0	0	0	0;						
	15	1	0.0582	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	16	1	0.0248	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	17	1	0.0424	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	18	1	0.119	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	19	1	0.118	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	20	1	1.62	0	0	0	1	1	0	30	1	1.1	0.9	0	1	3	0	0	0	0;						
	21	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	22	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	23	1	0.312	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	24	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	25	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	26	1	0.0599	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	27	1	0.007	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.05	0	0	0	0;						
	28	1	0.207	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	29	1	0.0857	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	30	1	0.256	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	31	1	0.0539	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	32	1	0.137	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	33	1	0.573	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	34	1	0.0575	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	35	1	0.175	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	36	1	0.0249	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	37	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	38	1	0.11	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	39	1	0.182	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	40	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	41	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	42	1	0.271	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	43	1	0.196	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	44	1	0.146	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	45	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	46	1	0.142	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	47	1	0.631	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	48	1	0.018	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	49	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	50	1	0.602	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.25	0	0	0	0;						
	51	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	52	1	0.0655	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	53	1	0.421	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	54	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	55	1	0.0929	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	56	1	0.104	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	57	1	0.0808	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	58	1	0.031	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	59	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	60	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	61	1	0.91	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.25	0	0	0	0;						
	62	1	0.0472	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	63	1	0.0186	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	64	1	0.55	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	65	1	0.659	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1	0	0	0	0;						
	66	1	0.742	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.25	0	0	0	0;						
	67	1	0.0772	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	68	1	0.242	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	69	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	70	1	0.0873	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.315	0	0	0	0;						
	71	1	0.0895	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	72	1	0.0778	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	73	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	74	1	0.51	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.43	0	0	0	0;						
	75	1	0.185	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.315	0	0	0	0;						
	76	1	0.127	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.315	0	0	0	0;						
	77	1	0.0593	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	78	1	0.447	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	79	1	0.222	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	80	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	81	1	0.0197	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.1	0	0	0	0;						
	82	1	0.028	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.2	0	0	0	0;						
	83	1	0.14	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	84	1	0.0429	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	85	1	0.0523	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	86	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	87	1	0.11	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	88	1	0.0417	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	89	1	0.323	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	90	1	0.15	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	91	1	0.1	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	92	1	0.0681	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	93	1	0.101	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	94	1	0.443	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1	0	0	0	0;						
	95	1	0.627	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	96	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	97	1	0.162	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.315	0	0	0	0;						
	98	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	99	1	1.09	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.88	0	0	0	0;						
	100	1	0.0818	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	101	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.2	0	0	0	0;						
	102	1	0.4	0	0	0	1	1	0	30	1	1.1	0.9	0	1	1.25	0	0	0	0;						
	103	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	104	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	105	1	0.0187	0	0	0	1	1	0	30	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	106	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	107	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	108	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	109	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	110	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	111	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	112	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	113	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	114	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	115	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	116	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	117	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	118	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	119	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	120	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	121	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	122	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	123	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	124	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	125	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	126	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	127	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	128	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	129	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	130	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	131	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	132	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	133	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	134	1	0	0	0	3.43	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	135	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	136	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	137	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	138	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	139	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	140	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	141	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	142	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	143	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	144	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	145	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	146	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	147	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	148	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	149	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	150	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	151	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	152	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	153	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	154	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	155	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	156	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	157	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	158	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	159	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	160	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	161	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	162	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	163	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	164	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	165	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	166	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	167	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	168	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	169	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	170	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	171	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	172	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	173	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	174	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	175	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	176	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	177	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	178	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	179	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	180	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	181	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	182	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	183	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	184	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	185	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	186	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	187	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	188	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	189	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	190	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
	191	1	0	0	0	0	1	1	0	30	1	1.1	0.9	0	0	0	0	0	0	0;						
];																										
																										
%% CAPACITOR BANK Data																										
%	bus_i	Node_ID	bank_ID	Qnom (Mvar)																						
mpc.capacitor_bank_dplan = {																										
	134	'134'	'1'	3.43053;																						
};																										
																										
%% generator data																										
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	ID				
mpc.gen = [																										
	2	0	0	10000	-10000	1	100	1	9999	-9999	0	0	0	0	0	0	0	0	0	0	0	1;				
];																										
																										
%% branch data																										
%	fbus	tbus	r	x	b	rateA (typical)	rateB (summer)	rateC (winter)	ratio	angle	status	angmin	angmax	step_size	actTap	minTap	maxTap	normalTap	nominalRatio	r_ip	r_n	r0	x0	b0	length (meter)	NormSTAT
mpc.branch = [																										
	137	111	0.00218	0.0012	0.000000678	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00261	0.00476	0.000000339	26.69	1;
	82	122	0.00161	0.000866	0.000000516	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00193	0.00344	0.000000258	19.78	1;
	181	141	0.00618	0.00362	0.00000231	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00759	0.015	0.00000115	85.48	1;
	166	163	0	0.0001	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.06	1;
	171	142	0.00223	0.00123	0.000000694	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00268	0.00487	0.000000347	27.33	1;
	188	181	0.00567	0.00332	0.00000212	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00696	0.0138	0.00000106	78.48	1;
	189	157	0.00382	0.00206	0.00000123	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00459	0.00817	0.000000613	46.98	1;
	136	117	0.0113	0.0103	0.00000675	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0153	0.0424	0.00000338	246.66	1;
	178	23	0.00262	0.00144	0.000000816	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00314	0.00572	0.000000408	32.09	1;
	79	121	0.000992	0.000535	0.000000318	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00119	0.00212	0.000000159	12.21	1;
	155	15	0.00133	0.000715	0.000000426	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0016	0.00284	0.000000213	16.34	1;
	174	155	0.00461	0.00827	0.0000055	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00788	0.0342	0.00000275	199.26	1;
	177	135	0.0154	0.0232	0.0000164	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0247	0.0973	0.00000733	574.7	1;
	187	173	0.00228	0.00123	0.000000731	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00274	0.00487	0.000000365	28.02	1;
	173	116	0.0079	0.00426	0.00000254	9.25	6.91	9.25	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0095	0.0169	0.00000127	97.3	1;
	67	124	0.0017	0.000915	0.000000545	9.25	6.91	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00204	0.00363	0.000000272	20.9	1;
	150	128	0.00417	0.00225	0.00000134	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00502	0.00894	0.00000067	51.4	1;
	92	167	0.0157	0.00849	0.00000506	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0189	0.0337	0.00000253	193.92	1;
	63	135	0.0382	0.0223	0.0000143	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0469	0.0928	0.00000713	528.03	1;
	167	19	0.000807	0.000435	0.000000259	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00097	0.00173	0.000000129	9.93	1;
	77	169	0.0123	0.00721	0.0000046	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0151	0.03	0.0000023	170.38	1;
	169	151	0.0161	0.00943	0.00000602	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0198	0.0392	0.00000301	222.82	1;
	165	29	0.00168	0.000903	0.000000538	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00201	0.00359	0.000000269	20.63	1;
	165	157	0.00896	0.00819	0.00000537	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0122	0.0337	0.00000268	196.08	1;
	152	133	0.00151	0.00138	0.000000904	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00205	0.00568	0.000000452	33.02	1;
	144	121	0.00178	0.00162	0.00000106	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00241	0.00668	0.000000532	38.86	1;
	152	121	0.00493	0.0045	0.00000295	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0067	0.0185	0.00000148	107.81	1;
	123	7	0.00167	0.000898	0.000000535	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.002	0.00357	0.000000267	20.51	1;
	189	151	0.0327	0.0176	0.0000105	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0393	0.07	0.00000525	402.45	1;
	57	127	0.000733	0.000395	0.000000235	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000881	0.00157	0.000000118	9.02	1;
	153	109	0.00479	0.00258	0.00000154	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00576	0.0103	0.00000077	59.02	1;
	161	26	0.00266	0.00144	0.000000856	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0032	0.0057	0.000000428	32.81	1;
	188	130	0.00854	0.005	0.00000319	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0105	0.0208	0.0000016	118.08	1;
	89	112	0.00332	0.00179	0.00000107	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00399	0.0071	0.000000533	40.84	1;
	84	116	0.00152	0.000819	0.000000488	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00183	0.00325	0.000000244	18.71	1;
	46	140	0.000882	0.000475	0.000000283	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00106	0.00189	0.000000142	10.86	1;
	174	139	0.00255	0.00457	0.00000304	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00435	0.0189	0.00000152	110.05	1;
	178	175	0.0101	0.00556	0.00000315	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0121	0.0221	0.00000157	123.92	1;
	97	171	0.00913	0.00503	0.00000285	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.011	0.02	0.00000142	111.98	1;
	170	27	0.00741	0.00399	0.00000238	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00891	0.0159	0.00000119	91.24	1;
	147	11	0.00104	0.000562	0.000000335	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00125	0.00223	0.000000168	12.85	1;
	186	162	0.00233	0.00418	0.00000278	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00399	0.0173	0.00000139	100.88	1;
	187	108	0.00408	0.0022	0.00000131	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0049	0.00873	0.000000655	50.21	1;
	161	153	0.00631	0.0034	0.00000203	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00758	0.0135	0.00000101	77.68	1;
	80	143	0.00611	0.0033	0.00000196	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00735	0.0131	0.000000982	75.28	1;
	161	124	0.00402	0.00217	0.00000129	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00484	0.00861	0.000000646	49.53	1;
	143	128	0.00426	0.0023	0.00000137	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00513	0.00913	0.000000684	52.49	1;
	187	154	0.00801	0.00432	0.00000257	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00963	0.0171	0.00000129	98.63	1;
	150	43	0.00306	0.00105	0.000000552	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00343	0.00407	0.000000276	22.58	1;
	85	126	0.000289	0.000169	0.000000108	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000355	0.000702	0.000000054	4	1;
	167	137	0.0214	0.0118	0.00000667	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0257	0.0468	0.00000334	262.53	1;
	140	108	0.00414	0.00223	0.00000133	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00498	0.00887	0.000000665	51.01	1;
	175	72	0.0182	0.00983	0.00000586	9.25	6.91	9.25	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0219	0.039	0.00000293	225	1;
	142	111	0.00405	0.00727	0.00000483	18.7	13.7	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00693	0.0301	0.00000242	175	1;
	184	118	0.00703	0.00379	0.00000226	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00846	0.0151	0.00000113	86.6	1;
	56	147	0.00206	0.00121	0.00000077	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00253	0.00501	0.000000385	28.5	1;
	90	176	0.000479	0.000258	0.000000154	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000576	0.00103	7.69E-08	5.9	1;
	28	111	0.00218	0.00117	0.000000699	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00262	0.00466	0.000000349	26.79	1;
	48	118	0.00961	0.00518	0.00000309	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0116	0.0206	0.00000154	118.35	1;
	81	115	0.0125	0.00672	0.00000401	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.015	0.0267	0.000002	153.6	1;
	182	172	0.00645	0.00377	0.00000241	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00792	0.0157	0.00000121	89.21	1;
	137	12	0.0022	0.00118	0.000000705	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00264	0.0047	0.000000352	27.03	1;
	113	112	0.00619	0.00334	0.00000199	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00744	0.0133	0.000000994	76.21	1;
	156	147	0.00487	0.00262	0.00000156	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00585	0.0104	0.000000781	59.92	1;
	165	112	0.00693	0.00373	0.00000222	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00833	0.0148	0.00000111	85.31	1;
	36	127	0.00181	0.000978	0.000000583	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00218	0.00389	0.000000291	22.34	1;
	71	129	0.00523	0.00306	0.00000195	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00642	0.0127	0.000000977	72.31	1;
	154	8	0.00101	0.000542	0.000000323	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00121	0.00215	0.000000161	12.38	1;
	174	129	0.0132	0.00772	0.00000493	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0162	0.0321	0.00000247	182.49	1;
	180	179	0	0.0001	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	55	145	0.00672	0.00393	0.00000251	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00825	0.0163	0.00000126	92.97	1;
	145	144	0.0068	0.00367	0.00000219	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00818	0.0146	0.00000109	83.79	1;
	160	62	0.00154	0.000832	0.000000496	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00186	0.0033	0.000000248	19	1;
	189	160	0.00805	0.00471	0.00000301	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00988	0.0196	0.0000015	111.33	1;
	35	117	0.00122	0.000657	0.000000391	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00146	0.00261	0.000000196	15	1;
	186	117	0.00641	0.00586	0.00000384	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00871	0.0241	0.00000192	140.26	1;
	156	49	0.0025	0.00135	0.000000803	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00301	0.00535	0.000000402	30.79	1;
	93	108	0.00465	0.0025	0.00000149	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00559	0.00995	0.000000746	57.2	1;
	172	44	0.00376	0.0022	0.00000141	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00462	0.00914	0.000000703	52.01	1;
	182	141	0.0224	0.0131	0.00000837	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0275	0.0545	0.00000419	309.92	1;
	177	111	0.00591	0.0106	0.00000705	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0101	0.0438	0.00000352	255.48	1;
	182	58	0.000438	0.000257	0.000000164	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000538	0.00107	8.19E-08	6.06	1;
	168	30	0.000567	0.000305	0.000000182	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000681	0.00121	0.000000091	6.98	1;
	148	146	0.00353	0.00549	0.00000401	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00581	0.0235	0.00000201	138.57	1;
	114	110	0.00489	0.00737	0.0000052	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00782	0.0309	0.00000233	182.28	1;
	141	114	0.0024	0.00362	0.00000255	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00384	0.0152	0.00000114	89.51	1;
	159	114	0.0137	0.00736	0.00000438	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0164	0.0292	0.00000219	168.09	1;
	140	123	0.00411	0.00221	0.00000132	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00494	0.0088	0.00000066	50.59	1;
	149	139	0.00666	0.0119	0.00000794	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0114	0.0494	0.00000397	287.89	1;
	156	31	0.00243	0.00131	0.000000782	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00293	0.00521	0.000000391	29.98	1;
	183	17	0.00078	0.00042	0.00000025	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000938	0.00167	0.000000125	9.6	1;
	87	109	0.00191	0.00103	0.000000614	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0023	0.00409	0.000000307	23.53	1;
	176	168	0.00684	0.00368	0.0000022	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00822	0.0146	0.0000011	84.17	1;
	191	6	0.00306	0.00165	0.000000983	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00368	0.00655	0.000000492	37.69	1;
	162	132	0.00113	0.0017	0.0000012	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0018	0.00712	0.000000536	42.04	1;
	105	107	0.00078	0.00042	0.00000025	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000937	0.00167	0.000000125	9.6	1;
	184	124	0.00805	0.00434	0.00000259	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00968	0.0172	0.00000129	99.14	1;
	120	113	0.00461	0.00248	0.00000148	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00554	0.00986	0.000000739	56.71	1;
	124	107	0.00233	0.00126	0.000000748	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0028	0.00499	0.000000374	28.7	1;
	164	119	0.00583	0.00314	0.00000187	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00701	0.0125	0.000000936	71.76	1;
	2	1	0.0111	0.387	0	31.5	31.5	31.5	1.00035	0	1	-360	360	1.5036	12	1	23	12	0.9521	0	0	0.199	0.18	0	0	1;
	184	127	0.0158	0.00852	0.00000508	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.019	0.0338	0.00000254	194.65	1;
	153	183	0.00599	0.00323	0.00000192	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0072	0.0128	0.000000962	73.76	1;
	185	119	0.00672	0.0104	0.00000763	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0111	0.0447	0.00000381	263.63	1;
	16	191	0.0725	0.0391	0.0000233	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0872	0.155	0.0000116	892.61	1;
	148	176	0.00868	0.00468	0.00000279	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0104	0.0186	0.00000139	106.91	1;
	119	148	0.00746	0.0116	0.00000847	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0123	0.0496	0.00000423	292.52	1;
	187	39	0.00246	0.00132	0.000000789	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00295	0.00526	0.000000394	30.25	1;
	53	186	0.00425	0.00229	0.00000136	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00511	0.00909	0.000000682	52.31	1;
	123	147	0.00764	0.00412	0.00000245	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00919	0.0164	0.00000123	94.1	1;
	183	106	0.00537	0.0029	0.00000173	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00646	0.0115	0.000000863	66.17	1;
	131	166	0	0.0002	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.15	1;
	146	122	0.0173	0.0201	0.0000142	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0255	0.085	0.0000071	498.83	1;
	138	34	0.0147	0.00797	0.00000465	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0176	0.0317	0.00000232	180.14	1;
	190	150	0.0275	0.0123	0.00000702	6.34	4.7805	6.3393	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.032	0.0484	0.00000351	275.28	1;
	154	133	0.0121	0.00753	0.00000461	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.015	0.0302	0.00000231	174.39	1;
	115	129	0.0101	0.00555	0.00000336	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0122	0.0223	0.00000168	127.82	1;
	126	177	0.0114	0.00622	0.00000373	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0138	0.0248	0.00000187	142.58	1;
	175	136	0.0101	0.00535	0.00000298	6.91	5.1962	6.9109	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.012	0.0209	0.00000149	117.02	1;
	135	136	0.00765	0.014	0.00000912	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0131	0.0567	0.00000456	330.55	1;
	20	152	0.000966	0.000561	0.00000972	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00292	0.00172	0.00000968	23.04	1;
	14	112	0.00259	0.0015	0.0000058	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00405	0.00537	0.00000544	37.83	1;
	18	116	0.00259	0.00118	0.0000334	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0092	0.00436	0.0000334	70.67	1;
	47	132	0.000439	0.0004	0.0000028	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00103	0.000909	0.00000276	8.9	1;
	132	110	0.0155	0.0235	0.0000165	18.3	13.2502	18.2905	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0248	0.0979	0.00000738	578.08	1;
	109	170	0.0173	0.00934	0.00000557	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0208	0.0371	0.00000278	213.41	1;
	99	127	0.003	0.00145	0.000026	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00827	0.00548	0.0000258	66.53	1;
	38	130	0.00219	0.00101	0.0000262	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0074	0.0038	0.0000262	57.51	1;
	115	21	0.0127	0.00792	0.00000474	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0156	0.0308	0.00000237	176.17	1;
	131	134	0	0.0016	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.25	1;
	94	130	0.00234	0.00106	0.0000282	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00793	0.00406	0.0000281	61.64	1;
	125	22	0	0.0004	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.14	1;
	157	191	0.0233	0.0127	0.00000749	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.028	0.0499	0.00000374	287.14	1;
	189	32	0.00279	0.00166	0.00000582	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00431	0.00646	0.00000537	43.51	1;
	100	154	0.00447	0.00213	0.0000301	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0107	0.00851	0.0000297	88.98	1;
	95	145	0.00138	0.000702	0.0000149	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00436	0.00241	0.0000149	34.12	1;
	41	126	0.00484	0.00343	0.00000181	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00594	0.0118	0.000000904	67.01	1;
	74	139	0.00252	0.00117	0.0000322	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00888	0.00428	0.0000321	70.01	1;
	145	51	0.00176	0.00145	0.000000565	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00211	0.00377	0.000000282	21.76	1;
	164	70	0.00601	0.00203	0.0000277	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0128	0.00788	0.0000274	88.98	1;
	83	173	0.00423	0.0012	0.0000258	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0103	0.00432	0.0000257	66.26	1;
	158	54	0	0.0006	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.08	1;
	158	78	0.000594	0.000815	0.00000793	14.5	13.8218	16.8875	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00216	0.000984	0.00000793	17.81	1;
	146	69	0.00122	0.00156	0.0000133	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00389	0.00243	0.0000132	33.91	1;
	167	60	0.0164	0.0101	0.00000613	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0201	0.0399	0.00000307	228.78	1;
	143	25	0.0187	0.0106	0.00000601	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0225	0.0401	0.00000301	234.2	1;
	149	59	0.00816	0.00739	0.00000435	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0108	0.0279	0.00000217	161.89	1;
	4	163	0	0.0006	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	61	120	0.00648	0.00343	0.0000196	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0111	0.0132	0.0000188	100.59	1;
	169	37	0.00116	0.00118	0.000000432	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00142	0.00281	0.000000216	16.1	1;
	163	5	0	0.0007	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.1	1;
	10	125	0.000352	0.00073	0.0000123	21.2	20.317	24.7856	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00221	0.00116	0.0000123	20.84	1;
	102	118	0.00427	0.00249	0.00000403	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00563	0.00905	0.00000338	55.75	1;
	33	140	0.00466	0.00129	0.0000282	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0113	0.00479	0.0000282	72.85	1;
	3	166	0	0.0006	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.04	1;
	50	120	0.00282	0.00123	0.0000344	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00964	0.00478	0.0000344	74.37	1;
	138	149	0.0334	0.0185	0.0000104	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0401	0.0731	0.00000521	409.89	1;
	52	109	0.00184	0.000878	0.0000214	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00611	0.00317	0.0000214	47.4	1;
	162	190	0.0113	0.0177	0.0000129	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0186	0.0754	0.00000643	444.06	1;
	168	13	0.00194	0.00155	0.000000623	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00233	0.00415	0.000000311	23.97	1;
	107	158	0.000553	0.000498	0.000000178	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000665	0.00118	8.88E-08	8.66	1;
	42	159	0.000812	0.0004	0.00000157	4.83	3.6893	4.8324	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00116	0.000785	0.00000153	6.4	1;
	1	131	0	0.0012	0	520	519.5633	519.5633	0	0	1	-360	360	0	0	0	0	0	0	0	0	0	0	0	0.13	1;
	159	45	0.00242	0.00212	0.0000231	4.83	3.6893	4.8324	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00701	0.00345	0.000023	52.64	1;
	64	113	0.00267	0.00118	0.0000325	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00913	0.00454	0.0000325	70.43	1;
	76	170	0.000602	0.000425	0.00000471	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00157	0.00112	0.00000467	12.77	1;
	68	188	0.000993	0.000576	0.0000103	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00306	0.00182	0.0000102	24.36	1;
	103	122	0.0182	0.011	0.00000868	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0224	0.0388	0.0000058	228.44	1;
	181	73	0.00449	0.00292	0.00000144	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0054	0.00961	0.000000721	55.35	1;
	86	160	0.0188	0.0122	0.0000106	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0238	0.0456	0.0000071	267.59	1;
	180	66	0.0217	0.00537	0.000139	10.4	9.7168	10.9639	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0544	0.0208	0.000139	346.05	1;
	91	188	0.00392	0.00182	0.0000356	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0111	0.00748	0.0000354	90.81	1;
	180	151	0.000313	0.001	0.00000281	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000881	0.000569	0.00000279	10.37	1;
	164	9	0.00759	0.0041	0.0000101	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0106	0.016	0.00000901	102.63	1;
	179	88	0.00532	0.0017	0.0000341	10.4	9.7168	10.9639	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0134	0.0051	0.0000341	86.99	1;
	138	96	0.00365	0.00251	0.00000114	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00438	0.00799	0.000000569	46.38	1;
	142	155	0.00177	0.00328	0.00000211	18.7	13.6659	18.6542	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00303	0.0131	0.00000106	76.6	1;
	125	185	0.000579	0.00101	0.00000415	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00144	0.00109	0.00000411	12.6	1;
	24	171	0.000461	0.0011	0.00000481	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00142	0.000819	0.00000479	13.05	1;
	178	98	0.00599	0.00383	0.00000192	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00722	0.0133	0.00000096	75.88	1;
	179	65	0.0062	0.00199	0.0000398	10.4	9.7168	10.9639	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0156	0.00595	0.0000398	100.99	1;
	118	113	0.0101	0.00573	0.00000326	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0122	0.0217	0.00000163	124.93	1;
	75	128	0.0039	0.00111	0.0000232	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0094	0.0041	0.0000231	60.68	1;
	133	185	0.00717	0.00679	0.0000043	13.1	9.6648	13.1463	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00975	0.027	0.00000215	156.94	1;
	40	110	0.00588	0.00294	0.0000273	8.63	6.4952	8.6256	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0125	0.00812	0.000027	93.12	1;
	123	101	0.000618	0.00103	0.000000198	9.25	6.9109	9.2492	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.000743	0.00132	9.92E-08	10.82	1;
	104	172	0.00611	0.00416	0.0000363	9.92	7.3785	9.9247	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.0138	0.0128	0.0000357	121.72	1;
	5	157	0.00185	0.00237	0.0000519	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00989	0.00737	0.0000517	126.05	1;
	144	4	0.00321	0.00513	0.000029	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.00877	0.0188	0.0000277	169.03	1;
	3	190	0.12	0.18	0.000417	18.8	13.562	18.8101	0	0	1	-360	360	0	0	0	0	0	0	0	0	0.236	0.772	0.000354	4883.66	1;
];																										
																										
%%-----  OPF Data  -----%%																										
%% generator cost data																										
%	1	startup	shutdown	n	x1	y1	...	xn	yn																	
%	2	startup	shutdown	n	c(n-1)	...	c0																			
mpc.gencost = [																										
	2	0	0	3	0	0	  0.00;																			
];																										
% mpc.tans																										
% from bus	to bus	min	max	totaltaps	tap																					
mpc.trans=[2	1	0.8353	1.17	23	12];																					
																										
